/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.item;

import codechicken.lib.inventory.InventorySimple;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.ItemUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import morph.avaritia.init.AvaritiaModContent;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MatterClusterItem
extends Item {
    private static final int INTERNAL_INV_SIZE = 512;
    public static final int CAPACITY = 4096;

    public MatterClusterItem(Item.Properties properties) {
        super(properties);
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> stacks) {
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_) {
            ItemUtils.dropInventory((Level)level, (BlockPos)player.m_142538_(), (Container)MatterClusterItem.readClusterInventory(stack));
        }
        player.m_21008_(hand, ItemStack.f_41583_);
        return InteractionResultHolder.m_19090_((Object)ItemStack.f_41583_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.m_41782_() || !stack.m_41784_().m_128425_("items", 9)) {
            return;
        }
        InventorySimple inventory = MatterClusterItem.readClusterInventory(stack);
        int total = Arrays.stream(inventory.items).mapToInt(ItemStack::m_41613_).sum();
        tooltip.add((Component)new TranslatableComponent("avaritia:matter_cluster.counter", new Object[]{total, Math.max(total, 4096)}));
        tooltip.add((Component)new TextComponent(""));
        if (Screen.m_96638_()) {
            Object2IntOpenHashMap itemCounts = new Object2IntOpenHashMap();
            for (ItemStack item2 : inventory.items) {
                if (item2.m_41619_()) break;
                itemCounts.put((Object)item2.m_41720_(), item2.m_41613_() + itemCounts.getOrDefault((Object)item2.m_41720_(), 0));
            }
            itemCounts.forEach((item, count) -> tooltip.add((Component)new TranslatableComponent(item.m_5524_()).m_130940_(item.m_41460_((ItemStack)new ItemStack((ItemLike)item)).f_43022_).m_7220_((Component)new TextComponent(" x " + count).m_130940_(ChatFormatting.GRAY))));
        } else {
            tooltip.add((Component)new TranslatableComponent("avaritia:matter_cluster.desc").m_130940_(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)new TranslatableComponent("avaritia:matter_cluster.desc2").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
        }
    }

    public static List<ItemStack> makeClusters(Collection<ItemStack> input) {
        LinkedList<ItemStack> clusters = new LinkedList<ItemStack>();
        LinkedList<ItemStack> stacks = new LinkedList<ItemStack>(input);
        while (!stacks.isEmpty()) {
            int totalInserted;
            int remainder;
            ItemStack stack;
            InventorySimple clusterInventory = new InventorySimple(512);
            for (totalInserted = 0; !stacks.isEmpty() && totalInserted < 4096; totalInserted += stack.m_41613_() - remainder) {
                stack = stacks.poll();
                remainder = InventoryUtils.insertItem((Container)clusterInventory, (ItemStack)stack, (boolean)false);
                if (remainder <= 0) continue;
                stack.m_41764_(remainder);
                stacks.add(stack);
                break;
            }
            if (totalInserted <= 0) continue;
            ItemStack cluster = new ItemStack((ItemLike)AvaritiaModContent.MATTER_CLUSTER.get());
            MatterClusterItem.writeClusterInventory(cluster, clusterInventory);
            clusters.add(cluster);
        }
        return clusters;
    }

    public static boolean mergeClusters(ItemStack donor, ItemStack recipient) {
        InventorySimple receivingInv = MatterClusterItem.readClusterInventory(recipient);
        int recipientCount = Arrays.stream(receivingInv.items).mapToInt(ItemStack::m_41613_).sum();
        if (recipientCount >= 4096) {
            return false;
        }
        boolean mergedAny = false;
        InventorySimple donorInv = MatterClusterItem.readClusterInventory(donor);
        for (ItemStack stack : donorInv.items) {
            if (stack.m_41619_()) break;
            int remainder = InventoryUtils.insertItem((Container)receivingInv, (ItemStack)stack, (boolean)false);
            if (remainder <= stack.m_41613_()) {
                mergedAny = true;
            }
            stack.m_41764_(remainder);
            if ((recipientCount += stack.m_41613_() - remainder) >= 4096) break;
        }
        MatterClusterItem.writeClusterInventory(recipient, receivingInv);
        int donorRemaining = Arrays.stream(donorInv.items).mapToInt(ItemStack::m_41613_).sum();
        if (donorRemaining == 0) {
            donor.m_41751_(null);
            donor.m_41764_(0);
        } else {
            MatterClusterItem.writeClusterInventory(donor, donorInv);
        }
        return mergedAny;
    }

    private static void writeClusterInventory(ItemStack cluster, InventorySimple clusterContents) {
        CompoundTag nbt = cluster.m_41784_();
        nbt.m_128365_("items", (Tag)MatterClusterItem.writeItemStacksToTag(clusterContents.items));
    }

    private static InventorySimple readClusterInventory(ItemStack cluster) {
        InventorySimple clusterInventory = new InventorySimple(512);
        if (cluster.m_41782_()) {
            MatterClusterItem.readItemStacksFromTag(clusterInventory.items, cluster.m_41784_().m_128437_("items", 10));
        }
        return clusterInventory;
    }

    private static ListTag writeItemStacksToTag(ItemStack[] items) {
        ListTag tagList = new ListTag();
        for (ItemStack item : items) {
            if (item.m_41619_()) continue;
            tagList.add((Object)item.m_41739_(new CompoundTag()));
        }
        return tagList;
    }

    private static void readItemStacksFromTag(ItemStack[] items, ListTag tagList) {
        for (int i = 0; i < tagList.size(); ++i) {
            items[i] = ItemStack.m_41712_((CompoundTag)tagList.m_128728_(i));
        }
    }
}

